using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using DotNet.FrameWork.Data;
namespace HaTeam.Dd.DAL
{
	/// <summary>
	/// ݷ:Dd_Admin
	/// </summary>
	public partial class Dd_Admin
	{
		public Dd_Admin()
		{}
		#region  Method

		/// <summary>
		/// õID
		/// </summary>
		public int GetMaxId()
		{
		return DbHelperSQL.GetMaxID("Admin_ID", "Dd_Admin"); 
		}

		/// <summary>
		/// Ƿڸü¼
		/// </summary>
		public bool Exists(int Admin_ID)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select count(1) from Dd_Admin");
			strSql.Append(" where Admin_ID=@Admin_ID");
			SqlParameter[] parameters = {
					new SqlParameter("@Admin_ID", SqlDbType.Int,4)
};
			parameters[0].Value = Admin_ID;

            return DbHelperSQL.GetExists(strSql.ToString(), parameters);
		}


		/// <summary>
		/// һ
		/// </summary>
		public int Add(HaTeam.Dd.Model.Dd_Admin model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("insert into Dd_Admin(");
			strSql.Append("Admin_Name,Admin_Pwd,Admin_Guid,Admin_Datetime,Admin_UpDatetime,Admin_Verify,Admin_Lock,Admin_State,Admin_Delete,Admin_Count,Admin_Order,Admin_Remark)");
			strSql.Append(" values (");
			strSql.Append("@Admin_Name,@Admin_Pwd,@Admin_Guid,@Admin_Datetime,@Admin_UpDatetime,@Admin_Verify,@Admin_Lock,@Admin_State,@Admin_Delete,@Admin_Count,@Admin_Order,@Admin_Remark)");
			strSql.Append(";select @@IDENTITY");
			SqlParameter[] parameters = {
					new SqlParameter("@Admin_Name", SqlDbType.NVarChar,50),
					new SqlParameter("@Admin_Pwd", SqlDbType.NVarChar,50),
					new SqlParameter("@Admin_Guid", SqlDbType.NChar,36),
					new SqlParameter("@Admin_Datetime", SqlDbType.DateTime),
					new SqlParameter("@Admin_UpDatetime", SqlDbType.DateTime),
					new SqlParameter("@Admin_Verify", SqlDbType.Int,4),
					new SqlParameter("@Admin_Lock", SqlDbType.Int,4),
					new SqlParameter("@Admin_State", SqlDbType.Int,4),
					new SqlParameter("@Admin_Delete", SqlDbType.Int,4),
					new SqlParameter("@Admin_Count", SqlDbType.Int,4),
					new SqlParameter("@Admin_Order", SqlDbType.Int,4),
					new SqlParameter("@Admin_Remark", SqlDbType.NText)};
			parameters[0].Value = model.Admin_Name;
			parameters[1].Value = model.Admin_Pwd;
			parameters[2].Value = model.Admin_Guid;
			parameters[3].Value = model.Admin_Datetime;
			parameters[4].Value = model.Admin_UpDatetime;
			parameters[5].Value = model.Admin_Verify;
			parameters[6].Value = model.Admin_Lock;
			parameters[7].Value = model.Admin_State;
			parameters[8].Value = model.Admin_Delete;
			parameters[9].Value = model.Admin_Count;
			parameters[10].Value = model.Admin_Order;
			parameters[11].Value = model.Admin_Remark;

			object obj = DbHelperSQL.GetSingle(strSql.ToString(),parameters);
			if (obj == null)
			{
				return 0;
			}
			else
			{
				return Convert.ToInt32(obj);
			}
		}
		/// <summary>
		/// һ
		/// </summary>
		public bool Update(HaTeam.Dd.Model.Dd_Admin model)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("update Dd_Admin set ");
			strSql.Append("Admin_Name=@Admin_Name,");
			strSql.Append("Admin_Pwd=@Admin_Pwd,");
			strSql.Append("Admin_Guid=@Admin_Guid,");
			strSql.Append("Admin_Datetime=@Admin_Datetime,");
			strSql.Append("Admin_UpDatetime=@Admin_UpDatetime,");
			strSql.Append("Admin_Verify=@Admin_Verify,");
			strSql.Append("Admin_Lock=@Admin_Lock,");
			strSql.Append("Admin_State=@Admin_State,");
			strSql.Append("Admin_Delete=@Admin_Delete,");
			strSql.Append("Admin_Count=@Admin_Count,");
			strSql.Append("Admin_Order=@Admin_Order,");
			strSql.Append("Admin_Remark=@Admin_Remark");
			strSql.Append(" where Admin_ID=@Admin_ID");
			SqlParameter[] parameters = {
					new SqlParameter("@Admin_Name", SqlDbType.NVarChar,50),
					new SqlParameter("@Admin_Pwd", SqlDbType.NVarChar,50),
					new SqlParameter("@Admin_Guid", SqlDbType.NChar,36),
					new SqlParameter("@Admin_Datetime", SqlDbType.DateTime),
					new SqlParameter("@Admin_UpDatetime", SqlDbType.DateTime),
					new SqlParameter("@Admin_Verify", SqlDbType.Int,4),
					new SqlParameter("@Admin_Lock", SqlDbType.Int,4),
					new SqlParameter("@Admin_State", SqlDbType.Int,4),
					new SqlParameter("@Admin_Delete", SqlDbType.Int,4),
					new SqlParameter("@Admin_Count", SqlDbType.Int,4),
					new SqlParameter("@Admin_Order", SqlDbType.Int,4),
					new SqlParameter("@Admin_Remark", SqlDbType.NText),
					new SqlParameter("@Admin_ID", SqlDbType.Int,4)};
			parameters[0].Value = model.Admin_Name;
			parameters[1].Value = model.Admin_Pwd;
			parameters[2].Value = model.Admin_Guid;
			parameters[3].Value = model.Admin_Datetime;
			parameters[4].Value = model.Admin_UpDatetime;
			parameters[5].Value = model.Admin_Verify;
			parameters[6].Value = model.Admin_Lock;
			parameters[7].Value = model.Admin_State;
			parameters[8].Value = model.Admin_Delete;
			parameters[9].Value = model.Admin_Count;
			parameters[10].Value = model.Admin_Order;
			parameters[11].Value = model.Admin_Remark;
			parameters[12].Value = model.Admin_ID;

			int rows=DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
			if (rows > 0)
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		/// <summary>
		/// ɾһ
		/// </summary>
		public bool Delete(int Admin_ID)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from Dd_Admin ");
			strSql.Append(" where Admin_ID=@Admin_ID");
			SqlParameter[] parameters = {
					new SqlParameter("@Admin_ID", SqlDbType.Int,4)
};
			parameters[0].Value = Admin_ID;

			int rows=DbHelperSQL.ExecuteSql(strSql.ToString(),parameters);
			if (rows > 0)
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		/// <summary>
		/// ɾһ
		/// </summary>
		public bool DeleteList(string Admin_IDlist )
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("delete from Dd_Admin ");
			strSql.Append(" where Admin_ID in ("+Admin_IDlist + ")  ");
			int rows=DbHelperSQL.ExecuteSqlInt(strSql.ToString());
			if (rows > 0)
			{
				return true;
			}
			else
			{
				return false;
			}
		}


		/// <summary>
		/// õһʵ
		/// </summary>
		public HaTeam.Dd.Model.Dd_Admin GetModel(int Admin_ID)
		{
			
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select  top 1 Admin_ID,Admin_Name,Admin_Pwd,Admin_Guid,Admin_Datetime,Admin_UpDatetime,Admin_Verify,Admin_Lock,Admin_State,Admin_Delete,Admin_Count,Admin_Order,Admin_Remark from Dd_Admin ");
			strSql.Append(" where Admin_ID=@Admin_ID");
			SqlParameter[] parameters = {
					new SqlParameter("@Admin_ID", SqlDbType.Int,4)
};
			parameters[0].Value = Admin_ID;

			HaTeam.Dd.Model.Dd_Admin model=new HaTeam.Dd.Model.Dd_Admin();
			DataSet ds=DbHelperSQL.GetDataSet(strSql.ToString(),parameters);
			if(ds.Tables[0].Rows.Count>0)
			{
				if(ds.Tables[0].Rows[0]["Admin_ID"].ToString()!="")
				{
					model.Admin_ID=int.Parse(ds.Tables[0].Rows[0]["Admin_ID"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Admin_Name"]!=null)
				{
				model.Admin_Name=ds.Tables[0].Rows[0]["Admin_Name"].ToString();
				}
				if(ds.Tables[0].Rows[0]["Admin_Pwd"]!=null)
				{
				model.Admin_Pwd=ds.Tables[0].Rows[0]["Admin_Pwd"].ToString();
				}
				if(ds.Tables[0].Rows[0]["Admin_Guid"]!=null)
				{
				model.Admin_Guid=ds.Tables[0].Rows[0]["Admin_Guid"].ToString();
				}
				if(ds.Tables[0].Rows[0]["Admin_Datetime"].ToString()!="")
				{
					model.Admin_Datetime=DateTime.Parse(ds.Tables[0].Rows[0]["Admin_Datetime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Admin_UpDatetime"].ToString()!="")
				{
					model.Admin_UpDatetime=DateTime.Parse(ds.Tables[0].Rows[0]["Admin_UpDatetime"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Admin_Verify"].ToString()!="")
				{
					model.Admin_Verify=int.Parse(ds.Tables[0].Rows[0]["Admin_Verify"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Admin_Lock"].ToString()!="")
				{
					model.Admin_Lock=int.Parse(ds.Tables[0].Rows[0]["Admin_Lock"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Admin_State"].ToString()!="")
				{
					model.Admin_State=int.Parse(ds.Tables[0].Rows[0]["Admin_State"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Admin_Delete"].ToString()!="")
				{
					model.Admin_Delete=int.Parse(ds.Tables[0].Rows[0]["Admin_Delete"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Admin_Count"].ToString()!="")
				{
					model.Admin_Count=int.Parse(ds.Tables[0].Rows[0]["Admin_Count"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Admin_Order"].ToString()!="")
				{
					model.Admin_Order=int.Parse(ds.Tables[0].Rows[0]["Admin_Order"].ToString());
				}
				if(ds.Tables[0].Rows[0]["Admin_Remark"]!=null)
				{
				model.Admin_Remark=ds.Tables[0].Rows[0]["Admin_Remark"].ToString();
				}
				return model;
			}
			else
			{
				return null;
			}
		}

		/// <summary>
		/// б
		/// </summary>
		public DataSet GetList(string strWhere)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select Admin_ID,Admin_Name,Admin_Pwd,Admin_Guid,Admin_Datetime,Admin_UpDatetime,Admin_Verify,Admin_Lock,Admin_State,Admin_Delete,Admin_Count,Admin_Order,Admin_Remark ");
			strSql.Append(" FROM Dd_Admin ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			return DbHelperSQL.GetDataSet(strSql.ToString());
		}

		/// <summary>
		/// ǰ
		/// </summary>
		public DataSet GetList(int Top,string strWhere,string filedOrder)
		{
			StringBuilder strSql=new StringBuilder();
			strSql.Append("select ");
			if(Top>0)
			{
				strSql.Append(" top "+Top.ToString());
			}
			strSql.Append(" Admin_ID,Admin_Name,Admin_Pwd,Admin_Guid,Admin_Datetime,Admin_UpDatetime,Admin_Verify,Admin_Lock,Admin_State,Admin_Delete,Admin_Count,Admin_Order,Admin_Remark ");
			strSql.Append(" FROM Dd_Admin ");
			if(strWhere.Trim()!="")
			{
				strSql.Append(" where "+strWhere);
			}
			strSql.Append(" order by " + filedOrder);
			return DbHelperSQL.GetDataSet(strSql.ToString());
		}

		/*
		/// <summary>
		/// ҳȡб
		/// </summary>
		public DataSet GetList(int PageSize,int PageIndex,string strWhere)
		{
			SqlParameter[] parameters = {
					new SqlParameter("@tblName", SqlDbType.VarChar, 255),
					new SqlParameter("@fldName", SqlDbType.VarChar, 255),
					new SqlParameter("@PageSize", SqlDbType.Int),
					new SqlParameter("@PageIndex", SqlDbType.Int),
					new SqlParameter("@IsReCount", SqlDbType.Bit),
					new SqlParameter("@OrderType", SqlDbType.Bit),
					new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
					};
			parameters[0].Value = "Dd_Admin";
			parameters[1].Value = "Admin_ID";
			parameters[2].Value = PageSize;
			parameters[3].Value = PageIndex;
			parameters[4].Value = 0;
			parameters[5].Value = 0;
			parameters[6].Value = strWhere;	
			return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
		}*/

		#endregion  Method
	}
}

